      PROGRAM RDMEAN
C
C     This program reads in data from pitot survey files, P*MEAN.DAT.
C     All data are stored in arrays as described below.
C
C     UREF        :  Upstream freestream velocity (m/s)
C     UE          :  Local freestream velocity (m/s)
C     TAVG        :  Average temperature (in Kelvin) during the survey
C     NU          :  Kinematic viscosity (m**2/s)
C     RHO         :  Density (kg/m**3)
C     DEL99       :  Boundary layer thickness (mm)
C     DEL         :  Clauser thickness (mm)
C     CF          :  Skin friction coefficient
C     DELST       :  Displacement thickness (mm)
C     THETA       :  Momentum thickness (mm)
C     H           :  Shape factor = DELST/THETA
C     G           :  Clauser shape factor
C     RTHETA      :  Reynolds number based on momentum thickness
C                       = Ue * Theta / Nu
C     Y           :  Height (in meters) of the effective center of 
C                       the pitot probe above the test wall 
C     UBYUE       :  Value of U (average streamwise velocity) at 
C                       height Y divided by Ue
C     UEYBYNU     :  Ue * Y / Nu
C     YPLUS       :  Utau * Y / Nu  ( Utau = friction velocity)
C     UPLUS       :  U / Utau
C     UDEV        :  UPLUS calculated - UPLUS determined from the
C                       Law of the Wall
C
      INTEGER*2   I, INDEX, LUKEY /5/, LUCRT /6/, LUIN /9/, PORTN
      REAL*4      UREF, TAVG, NU, RHO, UE, DEL99, DEL, CF, NPTS(9),
     +            DELST, THETA, H, G, RTHETA, Y(70), UBYUE(70),
     +            UEYBYNU(70), YPLUS(70), UPLUS(70), UDEV(70)
      CHARACTER   FILENAME*10
C
      NPTS(1) = 54
      NPTS(2) = 57
      NPTS(3) = 64
      NPTS(4) = 60
      NPTS(5) = 57
      NPTS(6) = 55
      NPTS(7) = 57
      NPTS(8) = 59
      NPTS(9) = 68
C
  100 FORMAT (' Enter the number of the port at which the survey',/,
     +        ' was taken --> ',$)
  500 FORMAT (I2)
  600 FORMAT (////, ' ', 17X, F6.2, 21X, F5.1, 21X, G11.3, 22X, F5.3,
     +        ///, 17X, F6.2, 15X, F7.2, 26X, F7.2, /, 7X, F8.5, 
     +        ///, 10X, F6.2, 19X, F6.2, 19X,
     +        F6.2, 23X, F6.2, /, 10X, F7.0, ////)  
  700 FORMAT (5X, I3, 6X, F7.3, 8X, F7.4, 9X, F7.0, 8X, F10.2, 
     +        9X, F5.2, 9X, F5.2)
C
      WRITE (LUCRT, 100)
      READ  (LUKEY, 500) PORTN
      FILENAME = 'P'//CHAR(PORTN+48)//'MEAN.DAT'
      OPEN (UNIT=LUIN, FILE=FILENAME, STATUS='OLD', READONLY)
      READ (LUIN, 600) UREF, TAVG, NU, RHO, UE, DEL99, DEL, CF,
     +                 DELST, THETA, H, G, RTHETA
      DO 900 I = 1, NPTS(PORTN)
         READ (LUIN, 700) INDEX, Y(I), UBYUE(I), UEYBYNU(I),
     +                    YPLUS(I), UPLUS(I), UDEV(I)
  900  CONTINUE
C
      STOP
      END     
