      PROGRAM RDCP
C
C     This program reads in data from the files CP1.DAT and CP2.DAT.
C     The data are stored in arrays as described below.
C
C     PDYNREF   :  Reference dynamic presure (in Pascals).
C     TAVG      :  Average temperature (in Kelvin) during the survey.
C     Y         :  Streamwise position (in meters) of each static
C                  pressure tap, referenced to the end of curvature.
C                  A negative value of Y corresponds to a position
C                  upstream from the end of curvature.  A positive 
C                  value of Y corresponds to a position downstream
C                  from the end of curvature.
C     DELP      :  Average pressure difference (in Pascals) between 
C                  the static pressure tap at position Y and the 
C                  upstream reference static pressure tap.
C     CP        :  Pressure coefficient = DELP / PDYNREF
C
      INTEGER*2  I, FILEN, NPTS, INDEX, LUKEY /5/, LUCRT /6/, LUIN /9/
      REAL*4     Y(60), DELP(60), CP(60), PDYNREF, TAVG
      CHARACTER  FILENAME*7     
C
  100 FORMAT (' Which file do you wish to read :',/,
     +        '    To read CP1.DAT, enter 1',/,
     +        '    To read CP2.DAT, enter 2',/,' --> ',$)
  500 FORMAT (I2)
  600 FORMAT ( ///, 24X, F5.1, 19X, F6.2, //)
  700 FORMAT ( /,' ', I3, 7X, F11.3, 6X, F11.3, 5X, F11.3)
C
      WRITE (LUCRT, 100)
      READ  (LUKEY, 500) FILEN
      IF (FILEN .EQ. 1) THEN
          NPTS = 58
        ELSEIF (FILEN .EQ. 2) THEN
          NPTS = 13
       ENDIF
      FILENAME = 'CP'//CHAR(FILEN+48)//'.DAT'
      OPEN (UNIT=LUIN, FILE=FILENAME, STATUS='OLD', READONLY)
      READ (LUIN, 600) PDYNREF, TAVG
      DO 900 I = 1, NPTS
         READ (LUIN, 700) INDEX, Y(I), DELP(I), CP(I)
  900  CONTINUE
C
      STOP
      END
