      PROGRAM RDINFO
C     
C     This program reads in the data contained in the file
C     INFO.DAT .  All information is strored in arrays as 
C     described below.
C
C     FILENM(I,J) : Name of data file.  I corresponds to the Port 
C                   number, J is as follows:
C                     J = 1 : mean flow data file
C                     J = 2 : hot wire file (u)
C                     J = 3 : hot wire file (u,v)
C                     J = 4 : hot wire file (u,w)
C
C     S(I)        : Streamwise position, in meters, measured from
C                   the end of curvature, of the probe tip when
C                   taking measurements at Port I.
C     CP(I)       : Static pressure coefficient at the streamwise
C                   position S(I).
C     CF(I)       : Skin friction coefficient, as deduced from 
C                   the velocity profile (see README.TXT) at
C                   the streamwise position S(I).
C     UREF(I,J)   : Measured upstream reference velocity corresponding
C                   to the data in file FILENM(I,J).
C     UTAU(I,J)   : Calculated friction velocity (see README.TXT)
C                   corresponding to the data in file FILENM(I,J).
C
C     DUM1, DUM2, DUM3 : Dummy variables
C  
C
      INTEGER*2 I, J, LUIN /6/
      REAL*4 S(9), CP(9), CF(9), UREF(9,4), UTAU(9,4), DUM1,
     +       DUM2, DUM3
      CHARACTER*10 FILENM(9,4)
C
  100 FORMAT (/)
  200 FORMAT (A10, 5(F10.5))
C
      OPEN (UNIT=LUIN, FILE='INFO.DAT', STATUS='OLD', READONLY)
      READ (LUIN, 100)
      DO 1000 I = 1,9
        DO 900 J = 1,4
          IF (J .EQ. 1) THEN
            READ (LUIN,200) FILENM(I,J), S(I), CP(I), CF(I),
     +                      UREF(I,J), UTAU(I,J)
           ELSE
            IF (I .NE. 2) THEN
             READ (LUIN,200) FILENM(I,J), DUM1, DUM2, DUM3,
     +                       UREF(I,J), UTAU(I,J)
            ENDIF
           ENDIF
  900   CONTINUE
 1000 CONTINUE
C
      STOP
      END
